/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRMusicRegion;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.feature.LOTRTreeType;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.map.LOTRRoadType;
import lotr.common.world.map.LOTRWaypoint;
import lotr.common.world.spawning.LOTRBiomeSpawnList;
import lotr.common.world.spawning.LOTREventSpawner;
import lotr.common.world.spawning.LOTRInvasions;
import lotr.common.world.spawning.LOTRSpawnList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenDagorlad
extends LOTRBiome {
    private NoiseGeneratorPerlin noiseDirt = new NoiseGeneratorPerlin(new Random(42956029606L), 1);
    private NoiseGeneratorPerlin noiseGravel = new NoiseGeneratorPerlin(new Random(7185609602367L), 1);
    private NoiseGeneratorPerlin noiseMordorGravel = new NoiseGeneratorPerlin(new Random(12480634985056L), 1);
    private WorldGenerator boulderGen = new LOTRWorldGenBoulder(Blocks.field_150348_b, 0, 1, 2);

    public LOTRBiomeGenDagorlad(int i, boolean major) {
        super(i, major);
        this.func_76745_m();
        this.field_76752_A = LOTRMod.mordorDirt;
        this.topBlockMeta = 0;
        this.field_76753_B = LOTRMod.mordorDirt;
        this.fillerBlockMeta = 0;
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.spawnableLOTRAmbientList.clear();
        LOTRBiomeSpawnList.SpawnListContainer[] arrspawnListContainer = new LOTRBiomeSpawnList.SpawnListContainer[]{LOTRBiomeSpawnList.entry(LOTRSpawnList.MORDOR_ORCS, 10), LOTRBiomeSpawnList.entry(LOTRSpawnList.MORDOR_BOMBARDIERS, 1), LOTRBiomeSpawnList.entry(LOTRSpawnList.MORDOR_WARGS, 2).setConquestOnly()};
        this.npcSpawnList.newFactionList(100).add(arrspawnListContainer);
        LOTRBiomeSpawnList.SpawnListContainer[] arrspawnListContainer2 = new LOTRBiomeSpawnList.SpawnListContainer[]{LOTRBiomeSpawnList.entry(LOTRSpawnList.GONDOR_SOLDIERS, 5), LOTRBiomeSpawnList.entry(LOTRSpawnList.RANGERS_ITHILIEN, 5)};
        this.npcSpawnList.newFactionList(0).add(arrspawnListContainer2);
        this.decorator.treesPerChunk = 0;
        this.decorator.flowersPerChunk = 0;
        this.decorator.grassPerChunk = 0;
        this.decorator.addTree(LOTRTreeType.CHARRED, 1000);
        this.biomeColors.setSky(5523773);
        this.biomeColors.setClouds(0x333333);
        this.biomeColors.setFog(0x666666);
        this.biomeColors.setWater(2498845);
        this.setBanditChance(LOTREventSpawner.EventChance.NEVER);
        this.invasionSpawns.addInvasion(LOTRInvasions.MORDOR, LOTREventSpawner.EventChance.COMMON);
        this.invasionSpawns.addInvasion(LOTRInvasions.MORDOR_BLACK_URUK, LOTREventSpawner.EventChance.UNCOMMON);
        this.invasionSpawns.addInvasion(LOTRInvasions.MORDOR_WARG, LOTREventSpawner.EventChance.UNCOMMON);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterDagorlad;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.DAGORLAD;
    }

    @Override
    public LOTRMusicRegion.Sub getBiomeMusic() {
        return LOTRMusicRegion.MORDOR.getSubregion("dagorlad");
    }

    @Override
    public boolean getEnableRiver() {
        return false;
    }

    @Override
    public LOTRRoadType getRoadBlock() {
        return LOTRRoadType.MORDOR;
    }

    @Override
    public void generateBiomeTerrain(World world, Random random, Block[] blocks, byte[] meta, int i, int k, double stoneNoise, int height, LOTRBiomeVariant variant) {
        Block topBlock_pre = this.field_76752_A;
        int topBlockMeta_pre = this.topBlockMeta;
        Block fillerBlock_pre = this.field_76753_B;
        int fillerBlockMeta_pre = this.fillerBlockMeta;
        double d1 = this.noiseDirt.func_151601_a((double)i * 0.09, (double)k * 0.09);
        double d2 = this.noiseDirt.func_151601_a((double)i * 0.6, (double)k * 0.6);
        double d3 = this.noiseGravel.func_151601_a((double)i * 0.09, (double)k * 0.09);
        double d4 = this.noiseGravel.func_151601_a((double)i * 0.6, (double)k * 0.6);
        double d5 = this.noiseMordorGravel.func_151601_a((double)i * 0.09, (double)k * 0.09);
        if (d5 + this.noiseMordorGravel.func_151601_a((double)i * 0.6, (double)k * 0.6) > 0.5) {
            this.field_76752_A = LOTRMod.mordorGravel;
            this.topBlockMeta = 0;
        } else if (d3 + d4 > 0.6) {
            this.field_76752_A = Blocks.field_150351_n;
            this.topBlockMeta = 0;
        } else if (d1 + d2 > 0.6) {
            this.field_76752_A = Blocks.field_150346_d;
            this.topBlockMeta = 1;
        }
        super.generateBiomeTerrain(world, random, blocks, meta, i, k, stoneNoise, height, variant);
        this.field_76752_A = topBlock_pre;
        this.topBlockMeta = topBlockMeta_pre;
        this.field_76753_B = fillerBlock_pre;
        this.fillerBlockMeta = fillerBlockMeta_pre;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        if (random.nextInt(24) == 0) {
            int boulders = 1 + random.nextInt(4);
            for (int l = 0; l < boulders; ++l) {
                int i1 = i + random.nextInt(16) + 8;
                int k1 = k + random.nextInt(16) + 8;
                this.boulderGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
            }
        }
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.05f;
    }

    @Override
    public int spawnCountMultiplier() {
        return 3;
    }
}

